//////////////////////////////////////////////
// Window.js
//
//////////////////////////////////////////////

/// Class ------------------------------------
	
nkWinUiTests.Window = class Window extends nkDebug.TestClass
{
	static instance = new Window ("nkWinUiTests.Window") ;

	system = null ;

	// Methods
	async testBackgroundColor ()
	{
		// Prepare window
		const manager = Window.instance.system.getComponentManager() ;
		const window = manager.createOrRetrieve("Test", nkWinUi.COMPONENT_TYPE.WINDOW) ;
		window.setSize(150, 100) ;
		window.setVisibleOnLoad(false) ;
		window.load() ;

		// Paint to image
		const windowImage = await window.paintToImage() ;

		// Check sanity
		nkDebug.TestUtils.areNumbersEqual(windowImage.getWidth(), 150, 0, "Wrong width") ;
		nkDebug.TestUtils.areNumbersEqual(windowImage.getHeight(), 100, 0, "Wrong height") ;
		nkWebUnitTests.ImageHandlingUtils.checkPixel(windowImage, new nkMaths.Vector (12, 12, 12, 255), 0, 0) ;
	}

	// Common test methods
	nkTests =
	{
		// Management
		__testInit__ : function ()
		{
			// Init nkGraphics
			Window.instance.system = new nkWinUi.System () ;

			const initResult = Window.instance.system.initialize() ;

			if (!initResult)
				console.log("Failure to initialize nkWinUi, bypassing Window test...")

			return initResult ;
		},
		__testShutdown__ : function ()
		{
			Window.instance.system.shutdown()  ;
			Window.instance.system.delete() ;
			Window.instance.system = null ;
		},

		// Constructors
		BackgroundColor : async function () {await Window.instance.testBackgroundColor() ;},
	}
}